<?php
require_once '../includes/auth.php';
checkAdmin();
require_once '../includes/db.php';

$message = '';
$csrf_token = generateCSRFToken();

// Handle Add Bed
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_bed'])) {
    check_csrf();
    $bed_number = clean_input($_POST['bed_number']);
    $type = clean_input($_POST['type']);
    $price = clean_input($_POST['price']);

    if (!empty($bed_number) && !empty($price)) {
        $stmt = $pdo->prepare("INSERT INTO beds (bed_number, type, price) VALUES (?, ?, ?)");
        if ($stmt->execute([$bed_number, $type, $price])) {
            $message = '<div class="alert alert-success">Bed added successfully!</div>';
        } else {
            $message = '<div class="alert alert-danger">Error adding bed.</div>';
        }
    } else {
        $message = '<div class="alert alert-danger">Please fill all fields.</div>';
    }
}

// Handle Delete Bed
if (isset($_GET['delete'])) {
    $id = clean_input($_GET['delete']);
    $stmt = $pdo->prepare("DELETE FROM beds WHERE id = ?");
    if ($stmt->execute([$id])) {
        $message = '<div class="alert alert-success">Bed deleted successfully!</div>';
    } else {
        $message = '<div class="alert alert-danger">Error deleting bed.</div>';
    }
}

// Fetch Beds
$beds = $pdo->query("SELECT * FROM beds ORDER BY bed_number ASC")->fetchAll();

include '../includes/header.php';
?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="index.php" class="list-group-item list-group-item-action">Dashboard</a>
            <a href="doctors.php" class="list-group-item list-group-item-action">Manage Doctors</a>
            <a href="departments.php" class="list-group-item list-group-item-action">Manage Departments</a>
            <a href="beds.php" class="list-group-item list-group-item-action active">Manage Beds</a>
            <a href="admissions.php" class="list-group-item list-group-item-action">IPD Admissions</a>
            <a href="pharmacy.php" class="list-group-item list-group-item-action">Pharmacy</a>
            <a href="reports.php" class="list-group-item list-group-item-action">Reports</a>
            <a href="../logout.php" class="list-group-item list-group-item-action text-danger">Logout</a>
        </div>
    </div>
    <div class="col-md-9">
        <h2>Manage Beds</h2>
        <?php echo $message; ?>

        <div class="card mb-4">
            <div class="card-header">Add New Bed</div>
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label>Bed Number/Name</label>
                            <input type="text" name="bed_number" class="form-control" required>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Type</label>
                            <select name="type" class="form-control">
                                <option value="General Ward">General Ward</option>
                                <option value="Private Room">Private Room</option>
                                <option value="ICU">ICU</option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Price / Day</label>
                            <input type="number" step="0.01" name="price" class="form-control" required>
                        </div>
                    </div>
                    <button type="submit" name="add_bed" class="btn btn-primary">Add Bed</button>
                </form>
            </div>
        </div>

        <div class="card">
            <div class="card-header">Existing Beds</div>
            <div class="card-body">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Bed Number</th>
                            <th>Type</th>
                            <th>Price</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($beds as $bed): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($bed['bed_number']); ?></td>
                            <td><?php echo htmlspecialchars($bed['type']); ?></td>
                            <td>$<?php echo number_format($bed['price'], 2); ?></td>
                            <td>
                                <span class="badge bg-<?php echo $bed['is_occupied'] ? 'danger' : 'success'; ?>">
                                    <?php echo $bed['is_occupied'] ? 'Occupied' : 'Available'; ?>
                                </span>
                            </td>
                            <td>
                                <a href="?delete=<?php echo $bed['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
