<?php
require_once '../includes/auth.php';
checkAdmin();
require_once '../includes/db.php';

// CSV Export Logic
if (isset($_GET['export_revenue'])) {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="revenue_report.csv"');
    $output = fopen('php://output', 'w');
    fputcsv($output, array('Invoice ID', 'Patient', 'Amount', 'Date', 'Status'));
    
    $sql = "SELECT i.id, u.name, i.amount, i.created_at, i.status 
            FROM invoices i 
            JOIN patients p ON i.patient_id = p.id 
            JOIN users u ON p.user_id = u.id 
            WHERE i.status = 'paid'";
    $rows = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($rows as $row) {
        fputcsv($output, $row);
    }
    fclose($output);
    exit();
}

// Fetch Stats
$revenue = $pdo->query("SELECT SUM(amount) FROM invoices WHERE status = 'paid'")->fetchColumn();
$pending_revenue = $pdo->query("SELECT SUM(amount) FROM invoices WHERE status = 'unpaid'")->fetchColumn();

$appointments_stats = $pdo->query("SELECT status, COUNT(*) as count FROM appointments GROUP BY status")->fetchAll(PDO::FETCH_KEY_PAIR);
$total_appointments = array_sum($appointments_stats);

include '../includes/header.php';
?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="index.php" class="list-group-item list-group-item-action">Dashboard</a>
            <a href="doctors.php" class="list-group-item list-group-item-action">Manage Doctors</a>
            <a href="departments.php" class="list-group-item list-group-item-action">Manage Departments</a>
            <a href="beds.php" class="list-group-item list-group-item-action">Manage Beds</a>
            <a href="admissions.php" class="list-group-item list-group-item-action">IPD Admissions</a>
            <a href="pharmacy.php" class="list-group-item list-group-item-action">Pharmacy</a>
            <a href="reports.php" class="list-group-item list-group-item-action active">Reports</a>
            <a href="../logout.php" class="list-group-item list-group-item-action text-danger">Logout</a>
        </div>
    </div>
    <div class="col-md-9">
        <h2>Reports & Analytics</h2>
        
        <div class="row mb-4">
            <div class="col-md-6">
                <div class="card text-white bg-success mb-3">
                    <div class="card-header">Total Revenue (Paid)</div>
                    <div class="card-body">
                        <h3 class="card-title">$<?php echo number_format($revenue, 2); ?></h3>
                        <p>Pending: $<?php echo number_format($pending_revenue, 2); ?></p>
                        <a href="?export_revenue=true" class="btn btn-light btn-sm">Export CSV</a>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card text-white bg-primary mb-3">
                    <div class="card-header">Appointments</div>
                    <div class="card-body">
                        <h3 class="card-title"><?php echo $total_appointments; ?> Total</h3>
                        <ul>
                            <li>Confirmed: <?php echo $appointments_stats['confirmed'] ?? 0; ?></li>
                            <li>Pending: <?php echo $appointments_stats['pending'] ?? 0; ?></li>
                            <li>Completed: <?php echo $appointments_stats['completed'] ?? 0; ?></li>
                            <li>Cancelled: <?php echo $appointments_stats['cancelled'] ?? 0; ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">System Activity Log (Recent 20)</div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Time</th>
                            <th>User</th>
                            <th>Action</th>
                            <th>IP</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $logs = $pdo->query("SELECT l.*, u.name FROM activity_logs l LEFT JOIN users u ON l.user_id = u.id ORDER BY l.created_at DESC LIMIT 20")->fetchAll();
                        foreach($logs as $log): ?>
                        <tr>
                            <td><?php echo $log['created_at']; ?></td>
                            <td><?php echo htmlspecialchars($log['name'] ?? 'System'); ?></td>
                            <td><?php echo htmlspecialchars($log['action']); ?></td>
                            <td><?php echo htmlspecialchars($log['ip_address']); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
