<?php
require_once '../includes/auth.php';
checkDoctor();
require_once '../includes/db.php';

$message = '';
$csrf_token = generateCSRFToken();
$user_id = $_SESSION['user_id'];
// Get Doctor ID
$stmt = $pdo->prepare("SELECT id FROM doctors WHERE user_id = ?");
$stmt->execute([$user_id]);
$doctor = $stmt->fetch();
$doctor_id = $doctor['id'];

// Handle Add Record
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_record'])) {
    check_csrf();
    $patient_id = clean_input($_POST['patient_id']);
    $diagnosis = clean_input($_POST['diagnosis']);
    
    // File Upload (Optional)
    $file_name = null;
    $uploadOk = 1;

    if (isset($_FILES['record_file']) && $_FILES['record_file']['size'] > 0) {
        $target_dir = "../uploads/";
        $file_name = time() . '_' . basename($_FILES["record_file"]["name"]);
        $target_file = $target_dir . $file_name;
        $fileType = strtolower(pathinfo($target_file,PATHINFO_EXTENSION));

        if($fileType != "pdf") {
            $message = '<div class="alert alert-danger">Sorry, only PDF files are allowed.</div>';
            $uploadOk = 0;
        }

        if ($uploadOk) {
            if (!move_uploaded_file($_FILES["record_file"]["tmp_name"], $target_file)) {
                $message = '<div class="alert alert-danger">Error uploading file.</div>';
                $uploadOk = 0;
            }
        }
    }

    if ($uploadOk && !empty($patient_id) && !empty($diagnosis)) {
        $stmt = $pdo->prepare("INSERT INTO medical_records (patient_id, doctor_id, diagnosis, file_path) VALUES (?, ?, ?, ?)");
        if ($stmt->execute([$patient_id, $doctor_id, $diagnosis, $file_name])) {
            $message = '<div class="alert alert-success">Medical record added successfully!</div>';
        } else {
            $message = '<div class="alert alert-danger">Error adding record.</div>';
        }
    } elseif ($uploadOk) {
        $message = '<div class="alert alert-danger">Please fill required fields.</div>';
    }
}

// Fetch Patients (All patients for now, ideally should be patients with appointments)
$patients = $pdo->query("SELECT p.id, u.name, u.email FROM patients p JOIN users u ON p.user_id = u.id")->fetchAll();

include '../includes/header.php';
?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="index.php" class="list-group-item list-group-item-action">Dashboard</a>
            <a href="medical_records.php" class="list-group-item list-group-item-action active">Medical Records</a>
            <a href="prescriptions.php" class="list-group-item list-group-item-action">Prescriptions</a>
            <a href="../logout.php" class="list-group-item list-group-item-action text-danger">Logout</a>
        </div>
    </div>
    <div class="col-md-9">
        <h2>Medical Records</h2>
        <?php echo $message; ?>

        <div class="card mb-4">
            <div class="card-header">Add Medical Record</div>
            <div class="card-body">
                <form method="POST" action="" enctype="multipart/form-data">
                    <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                    <div class="mb-3">
                        <label>Select Patient</label>
                        <select name="patient_id" class="form-control" required>
                            <option value="">Select Patient</option>
                            <?php foreach($patients as $pat): ?>
                                <option value="<?php echo $pat['id']; ?>"><?php echo htmlspecialchars($pat['name']); ?> (<?php echo htmlspecialchars($pat['email']); ?>)</option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label>Diagnosis / Notes</label>
                        <textarea name="diagnosis" class="form-control" rows="5" required></textarea>
                    </div>
                    <div class="mb-3">
                        <label>Attach Report (PDF only) - Optional</label>
                        <input type="file" name="record_file" class="form-control" accept=".pdf">
                    </div>
                    <button type="submit" name="add_record" class="btn btn-primary">Add Record</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
