<?php
require_once '../includes/auth.php';
checkDoctor();
require_once '../includes/db.php';

$message = '';
$csrf_token = generateCSRFToken();
$user_id = $_SESSION['user_id'];
// Get Doctor ID
$stmt = $pdo->prepare("SELECT id FROM doctors WHERE user_id = ?");
$stmt->execute([$user_id]);
$doctor = $stmt->fetch();
$doctor_id = $doctor['id'];

// Handle Add Prescription
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_prescription'])) {
    check_csrf();
    $patient_id = clean_input($_POST['patient_id']);
    $medicines = clean_input($_POST['medicines']);
    $instructions = clean_input($_POST['instructions']);

    if (!empty($patient_id) && !empty($medicines)) {
        $stmt = $pdo->prepare("INSERT INTO prescriptions (patient_id, doctor_id, medicines, instructions) VALUES (?, ?, ?, ?)");
        if ($stmt->execute([$patient_id, $doctor_id, $medicines, $instructions])) {
            $message = '<div class="alert alert-success">Prescription created successfully!</div>';
        } else {
            $message = '<div class="alert alert-danger">Error creating prescription.</div>';
        }
    } else {
        $message = '<div class="alert alert-danger">Please fill required fields.</div>';
    }
}

// Fetch Patients
$patients = $pdo->query("SELECT p.id, u.name, u.email FROM patients p JOIN users u ON p.user_id = u.id")->fetchAll();

include '../includes/header.php';
?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="index.php" class="list-group-item list-group-item-action">Dashboard</a>
            <a href="medical_records.php" class="list-group-item list-group-item-action">Medical Records</a>
            <a href="prescriptions.php" class="list-group-item list-group-item-action active">Prescriptions</a>
            <a href="../logout.php" class="list-group-item list-group-item-action text-danger">Logout</a>
        </div>
    </div>
    <div class="col-md-9">
        <h2>Prescriptions</h2>
        <?php echo $message; ?>

        <div class="card mb-4">
            <div class="card-header">Create Prescription</div>
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                    <div class="mb-3">
                        <label>Select Patient</label>
                        <select name="patient_id" class="form-control" required>
                            <option value="">Select Patient</option>
                            <?php foreach($patients as $pat): ?>
                                <option value="<?php echo $pat['id']; ?>"><?php echo htmlspecialchars($pat['name']); ?> (<?php echo htmlspecialchars($pat['email']); ?>)</option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label>Medicines</label>
                        <textarea name="medicines" class="form-control" rows="5" placeholder="Medicine Name - Dosage - Frequency" required></textarea>
                    </div>
                    <div class="mb-3">
                        <label>Instructions / Advice</label>
                        <textarea name="instructions" class="form-control" rows="3"></textarea>
                    </div>
                    <button type="submit" name="add_prescription" class="btn btn-primary">Create Prescription</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
