<?php
// Helper Functions

function clean_input($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

function redirect($url) {
    header("Location: " . $url);
    exit();
}

function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function isAdmin() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'admin';
}

function isDoctor() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'doctor';
}

function isPatient() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'patient';
}

function isStaff() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'staff';
}

// Security & Logging Functions

function generateCSRFToken() {
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

function verifyCSRFToken($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

function check_csrf() {
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        if (!isset($_POST['csrf_token']) || !verifyCSRFToken($_POST['csrf_token'])) {
            die('CSRF validation failed.');
        }
    }
}

function logActivity($pdo, $user_id, $action) {
    try {
        $stmt = $pdo->prepare("INSERT INTO activity_logs (user_id, action, ip_address) VALUES (?, ?, ?)");
        $stmt->execute([$user_id, $action, $_SERVER['REMOTE_ADDR']]);
    } catch (Exception $e) {
        // Silently fail logging to not disrupt user experience
    }
}

function sendEmail($to, $subject, $message) {
    // Basic PHP mail() wrapper - Configure SMTP on server for reliability
    $headers = "From: no-reply@hms.com" . "\r\n" .
               "Reply-To: no-reply@hms.com" . "\r\n" .
               "X-Mailer: PHP/" . phpversion();
    // mail($to, $subject, $message, $headers); // Uncomment on live server
    // For now, we simulate success
    return true;
}
?>
