<?php
session_start();
require_once 'includes/config.php';
include 'includes/header.php';
?>

<div class="jumbotron text-center mt-5">
    <h1 class="display-4">Welcome to <?php echo APP_NAME; ?></h1>
    <p class="lead">Efficient and reliable hospital management system.</p>
    <hr class="my-4">
    <p>Manage appointments, doctors, and patients with ease.</p>
    <?php if(!isset($_SESSION['user_id'])): ?>
        <a class="btn btn-primary btn-lg" href="login.php" role="button">Login</a>
        <a class="btn btn-secondary btn-lg" href="register.php" role="button">Register</a>
    <?php else: ?>
        <p>You are logged in as <strong><?php echo htmlspecialchars($_SESSION['role']); ?></strong>.</p>
    <?php endif; ?>
</div>

<div class="row mt-5">
    <div class="col-md-4">
        <div class="card">
            <div class="card-body text-center">
                <h5 class="card-title">For Patients</h5>
                <p class="card-text">Book appointments and view your medical history.</p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-body text-center">
                <h5 class="card-title">For Doctors</h5>
                <p class="card-text">Manage your schedule and view patient details.</p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-body text-center">
                <h5 class="card-title">For Admin</h5>
                <p class="card-text">Manage the entire hospital system efficiently.</p>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
