<?php
require_once '../includes/auth.php';
checkPatient();
require_once '../includes/db.php';

$message = '';
$csrf_token = generateCSRFToken();
$user_id = $_SESSION['user_id'];

// Get Patient ID
$stmt = $pdo->prepare("SELECT id FROM patients WHERE user_id = ?");
$stmt->execute([$user_id]);
$patient = $stmt->fetch();
$patient_id = $patient['id'];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    check_csrf();
    $doctor_id = clean_input($_POST['doctor_id']);
    $date = clean_input($_POST['date']);
    $time = clean_input($_POST['time']);
    $reason = clean_input($_POST['reason']);

    if (!empty($doctor_id) && !empty($date) && !empty($time)) {
        try {
            $stmt = $pdo->prepare("INSERT INTO appointments (patient_id, doctor_id, appointment_date, appointment_time, reason, status) VALUES (?, ?, ?, ?, ?, 'pending')");
            $stmt->execute([$patient_id, $doctor_id, $date, $time, $reason]);
            $message = '<div class="alert alert-success">Appointment booked successfully! Status: Pending.</div>';
        } catch (Exception $e) {
            $message = '<div class="alert alert-danger">Error booking appointment.</div>';
        }
    } else {
        $message = '<div class="alert alert-danger">Please fill all required fields.</div>';
    }
}

// Fetch Doctors
$sql = "SELECT d.id, u.name, dept.name as dept_name 
        FROM doctors d 
        JOIN users u ON d.user_id = u.id 
        JOIN departments dept ON d.department_id = dept.id";
$doctors = $pdo->query($sql)->fetchAll();

include '../includes/header.php';
?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="index.php" class="list-group-item list-group-item-action">Dashboard</a>
            <a href="book-appointment.php" class="list-group-item list-group-item-action active">Book Appointment</a>
            <a href="appointments.php" class="list-group-item list-group-item-action">My Appointments</a>
            <a href="profile.php" class="list-group-item list-group-item-action">Update Profile</a>
            <a href="../logout.php" class="list-group-item list-group-item-action text-danger">Logout</a>
        </div>
    </div>
    <div class="col-md-9">
        <h2>Book Appointment</h2>
        <?php echo $message; ?>

        <div class="card">
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                    <div class="mb-3">
                        <label>Select Doctor</label>
                        <select name="doctor_id" class="form-control" required>
                            <option value="">Select Doctor</option>
                            <?php foreach($doctors as $doc): ?>
                                <option value="<?php echo $doc['id']; ?>">Dr. <?php echo htmlspecialchars($doc['name']); ?> (<?php echo htmlspecialchars($doc['dept_name']); ?>)</option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label>Date</label>
                            <input type="date" name="date" class="form-control" required min="<?php echo date('Y-m-d'); ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Time</label>
                            <input type="time" name="time" class="form-control" required>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label>Reason for Visit</label>
                        <textarea name="reason" class="form-control"></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary">Book Appointment</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
