<?php
require_once '../includes/auth.php';
checkPatient();
require_once '../includes/db.php';

$user_id = $_SESSION['user_id'];
// Get Patient ID
$stmt = $pdo->prepare("SELECT id FROM patients WHERE user_id = ?");
$stmt->execute([$user_id]);
$patient = $stmt->fetch();
$patient_id = $patient['id'];

// Fetch Lab Results
$stmt = $pdo->prepare("SELECT * FROM lab_tests WHERE patient_id = ? ORDER BY created_at DESC");
$stmt->execute([$patient_id]);
$results = $stmt->fetchAll();

include '../includes/header.php';
?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="index.php" class="list-group-item list-group-item-action">Dashboard</a>
            <a href="book-appointment.php" class="list-group-item list-group-item-action">Book Appointment</a>
            <a href="appointments.php" class="list-group-item list-group-item-action">My Appointments</a>
            <a href="medical_records.php" class="list-group-item list-group-item-action">Medical Records</a>
            <a href="prescriptions.php" class="list-group-item list-group-item-action">Prescriptions</a>
            <a href="lab_results.php" class="list-group-item list-group-item-action active">Lab Results</a>
            <a href="invoices.php" class="list-group-item list-group-item-action">Invoices</a>
            <a href="profile.php" class="list-group-item list-group-item-action">Update Profile</a>
            <a href="../logout.php" class="list-group-item list-group-item-action text-danger">Logout</a>
        </div>
    </div>
    <div class="col-md-9">
        <h2>Lab Results</h2>
        <?php if(count($results) > 0): ?>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Test Name</th>
                        <th>Status</th>
                        <th>File</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($results as $res): ?>
                    <tr>
                        <td><?php echo $res['created_at']; ?></td>
                        <td><?php echo htmlspecialchars($res['test_name']); ?></td>
                        <td>
                            <span class="badge bg-<?php echo $res['status'] == 'completed' ? 'success' : 'warning'; ?>">
                                <?php echo ucfirst($res['status']); ?>
                            </span>
                        </td>
                        <td>
                            <?php if($res['result_file']): ?>
                                <a href="../uploads/<?php echo $res['result_file']; ?>" target="_blank" class="btn btn-sm btn-info">View Report</a>
                            <?php else: ?>
                                <span class="text-muted">Pending</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="alert alert-info">No lab results found.</div>
        <?php endif; ?>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
