<?php
require_once '../includes/auth.php';
checkPatient();
require_once '../includes/db.php';

$user_id = $_SESSION['user_id'];
// Get Patient ID
$stmt = $pdo->prepare("SELECT id FROM patients WHERE user_id = ?");
$stmt->execute([$user_id]);
$patient = $stmt->fetch();
$patient_id = $patient['id'];

// Fetch Records
$sql = "SELECT m.*, u.name as doctor_name 
        FROM medical_records m 
        JOIN doctors d ON m.doctor_id = d.id 
        JOIN users u ON d.user_id = u.id 
        WHERE m.patient_id = ? 
        ORDER BY m.created_at DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute([$patient_id]);
$records = $stmt->fetchAll();

include '../includes/header.php';
?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="index.php" class="list-group-item list-group-item-action">Dashboard</a>
            <a href="book-appointment.php" class="list-group-item list-group-item-action">Book Appointment</a>
            <a href="appointments.php" class="list-group-item list-group-item-action">My Appointments</a>
            <a href="medical_records.php" class="list-group-item list-group-item-action active">Medical Records</a>
            <a href="prescriptions.php" class="list-group-item list-group-item-action">Prescriptions</a>
            <a href="lab_results.php" class="list-group-item list-group-item-action">Lab Results</a>
            <a href="invoices.php" class="list-group-item list-group-item-action">Invoices</a>
            <a href="profile.php" class="list-group-item list-group-item-action">Update Profile</a>
            <a href="../logout.php" class="list-group-item list-group-item-action text-danger">Logout</a>
        </div>
    </div>
    <div class="col-md-9">
        <h2>Medical Records</h2>
        <?php if(count($records) > 0): ?>
            <div class="card">
                <div class="card-body">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Doctor</th>
                                <th>Diagnosis</th>
                                <th>File</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($records as $rec): ?>
                            <tr>
                                <td><?php echo $rec['created_at']; ?></td>
                                <td>Dr. <?php echo htmlspecialchars($rec['doctor_name']); ?></td>
                                <td><?php echo nl2br(htmlspecialchars($rec['diagnosis'])); ?></td>
                                <td>
                                    <?php if($rec['file_path']): ?>
                                        <a href="../uploads/<?php echo $rec['file_path']; ?>" target="_blank" class="btn btn-sm btn-info">Download</a>
                                    <?php else: ?>
                                        <span class="text-muted">No file</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php else: ?>
            <div class="alert alert-info">No medical records found.</div>
        <?php endif; ?>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
