<?php
require_once '../includes/auth.php';
require_once '../includes/db.php';

// Verify Login (Patient or Doctor can print)
if (!isLoggedIn()) {
    die("Access Denied");
}

if (!isset($_GET['id'])) {
    die("Invalid Request");
}

$id = clean_input($_GET['id']);

// Fetch Prescription
$sql = "SELECT p.*, u.name as doctor_name, pat_u.name as patient_name, pat.gender, pat.dob 
        FROM prescriptions p 
        JOIN doctors d ON p.doctor_id = d.id 
        JOIN users u ON d.user_id = u.id 
        JOIN patients pat ON p.patient_id = pat.id
        JOIN users pat_u ON pat.user_id = pat_u.id
        WHERE p.id = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$id]);
$prescription = $stmt->fetch();

if (!$prescription) {
    die("Prescription not found.");
}

// Basic Access Control: Ensure patient owns it or user is doctor/admin
if (isPatient()) {
    $user_id = $_SESSION['user_id'];
    $stmt = $pdo->prepare("SELECT id FROM patients WHERE user_id = ?");
    $stmt->execute([$user_id]);
    $patient = $stmt->fetch();
    if ($patient['id'] != $prescription['patient_id']) {
        die("Access Denied");
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Prescription #<?php echo $prescription['id']; ?></title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        .header { text-align: center; border-bottom: 2px solid #000; padding-bottom: 10px; margin-bottom: 20px; }
        .info { display: flex; justify-content: space-between; margin-bottom: 20px; }
        .content { margin-bottom: 20px; }
        .footer { text-align: center; margin-top: 50px; font-size: 12px; }
    </style>
</head>
<body>
    <div class="header">
        <h1>Hospital Management System</h1>
        <p>123 Health St, City, Country | Phone: +1 234 567 890</p>
    </div>

    <div class="info">
        <div>
            <strong>Doctor:</strong> Dr. <?php echo htmlspecialchars($prescription['doctor_name']); ?><br>
            <strong>Date:</strong> <?php echo date('d-M-Y', strtotime($prescription['created_at'])); ?>
        </div>
        <div>
            <strong>Patient:</strong> <?php echo htmlspecialchars($prescription['patient_name']); ?><br>
            <strong>Gender:</strong> <?php echo $prescription['gender']; ?><br>
            <strong>DOB:</strong> <?php echo $prescription['dob']; ?>
        </div>
    </div>

    <div class="content">
        <h3>Rx</h3>
        <p style="white-space: pre-line;"><?php echo htmlspecialchars($prescription['medicines']); ?></p>
        
        <?php if($prescription['instructions']): ?>
        <h3>Instructions</h3>
        <p style="white-space: pre-line;"><?php echo htmlspecialchars($prescription['instructions']); ?></p>
        <?php endif; ?>
    </div>

    <div class="footer">
        <p>This is a computer-generated document.</p>
    </div>
    
    <script>
        window.print();
    </script>
</body>
</html>
