<?php
require_once '../includes/auth.php';
checkStaff();
require_once '../includes/db.php';

$message = '';
$csrf_token = generateCSRFToken();

// Handle Invoice Generation
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['create_invoice'])) {
    check_csrf();
    $patient_id = clean_input($_POST['patient_id']);
    $amount = clean_input($_POST['amount']);
    $description = clean_input($_POST['description']);

    if (!empty($patient_id) && !empty($amount)) {
        $stmt = $pdo->prepare("INSERT INTO invoices (patient_id, amount, description, status) VALUES (?, ?, ?, 'unpaid')");
        if ($stmt->execute([$patient_id, $amount, $description])) {
            $message = '<div class="alert alert-success">Invoice generated successfully!</div>';
        } else {
            $message = '<div class="alert alert-danger">Error generating invoice.</div>';
        }
    } else {
        $message = '<div class="alert alert-danger">Please fill all fields.</div>';
    }
}

// Handle Mark as Paid
if (isset($_GET['pay'])) {
    $invoice_id = clean_input($_GET['pay']);
    $stmt = $pdo->prepare("UPDATE invoices SET status = 'paid' WHERE id = ?");
    if ($stmt->execute([$invoice_id])) {
        $message = '<div class="alert alert-success">Invoice marked as paid!</div>';
    }
}

// Fetch Patients
$patients = $pdo->query("SELECT p.id, u.name, u.email FROM patients p JOIN users u ON p.user_id = u.id")->fetchAll();

// Fetch Invoices
$invoices = $pdo->query("SELECT i.*, u.name as patient_name FROM invoices i JOIN patients p ON i.patient_id = p.id JOIN users u ON p.user_id = u.id ORDER BY i.created_at DESC")->fetchAll();

include '../includes/header.php';
?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="index.php" class="list-group-item list-group-item-action">Dashboard</a>
            <a href="lab.php" class="list-group-item list-group-item-action">Laboratory</a>
            <a href="billing.php" class="list-group-item list-group-item-action active">Billing</a>
            <a href="../logout.php" class="list-group-item list-group-item-action text-danger">Logout</a>
        </div>
    </div>
    <div class="col-md-9">
        <h2>Billing System</h2>
        <?php echo $message; ?>

        <div class="card mb-4">
            <div class="card-header">Generate Invoice</div>
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                    <div class="mb-3">
                        <label>Select Patient</label>
                        <select name="patient_id" class="form-control" required>
                            <option value="">Select Patient</option>
                            <?php foreach($patients as $pat): ?>
                                <option value="<?php echo $pat['id']; ?>"><?php echo htmlspecialchars($pat['name']); ?> (<?php echo htmlspecialchars($pat['email']); ?>)</option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label>Amount ($)</label>
                        <input type="number" step="0.01" name="amount" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Description</label>
                        <textarea name="description" class="form-control" required></textarea>
                    </div>
                    <button type="submit" name="create_invoice" class="btn btn-primary">Generate Invoice</button>
                </form>
            </div>
        </div>

        <div class="card">
            <div class="card-header">Invoices</div>
            <div class="card-body">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Patient</th>
                            <th>Amount</th>
                            <th>Description</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($invoices as $inv): ?>
                        <tr>
                            <td><?php echo $inv['id']; ?></td>
                            <td><?php echo htmlspecialchars($inv['patient_name']); ?></td>
                            <td>$<?php echo number_format($inv['amount'], 2); ?></td>
                            <td><?php echo htmlspecialchars($inv['description']); ?></td>
                            <td>
                                <span class="badge bg-<?php echo $inv['status'] == 'paid' ? 'success' : 'danger'; ?>">
                                    <?php echo ucfirst($inv['status']); ?>
                                </span>
                            </td>
                            <td>
                                <?php if($inv['status'] == 'unpaid'): ?>
                                    <a href="?pay=<?php echo $inv['id']; ?>" class="btn btn-success btn-sm" onclick="return confirm('Mark as paid?')">Mark Paid</a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
